// Cartesian.H,v 0.9
//
// Copyright 2000 by Roman Kantor.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public License
// version 2 as published by the Free Software Foundation.
//
// This library is distributed  WITHOUT ANY WARRANTY;
// WITHOUT even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


#include <math.h>

#include <fftw.h>

#include <FL/Fl.H>
#include <FL/Fl_Overlay_Window.H>
#include <FL/Fl_Light_Button.H>
#include "../Cartesian.H"
#include <FL/fl_draw.H>

fftw_complex in[8192];
fftw_complex out[8192];
fftw_plan p;
double plot[4096];

const double PI = 3.1416;
const double MIN_FREQ = 100;
const double MAX_FREQ = 4000;
const double FREQ_COEF = 1.15;

Ca_X_Axis *frequency;
Ca_Y_Axis *current;
Ca_Y_Axis *power;
Ca_Y_Axis *phase;
Fl_Light_Button *log_amp;
Fl_Light_Button *log_freq;

double R = 600;
double L = 0.16;
double C = 1.6e-7;
double U = 1;

Ca_Canvas *canvas;

void type_callback(Fl_Widget *, void *)
{
	power->scale((CA_LOG*log_amp->value()) | CA_REV*log_freq->value());
	frequency->scale(CA_LOG*log_freq->value());
}

void next_freq(void *)
{
    static double f = MIN_FREQ;
    static Ca_LinePoint *P_I = 0;
    static Ca_PolyLine *P_P = 0;
    static Ca_Line *L_L = 0;
    int i;
    
    double XL=2*PI*f*L;
    double XC=1/(2*PI*f*C);
    double I, P, fi;

    for (i = 0;  i < 4096;  i++)
    {
        in[i].re = 0.0;
        in[i].im = 42.0;
        in[i].im = (rand() & 0x1)  ?  1.0  :  -1.0;
        in[i].im *= pow(10.0, -1.0/20.0);
        in[i].im *= 305360.0/512.0;
        in[8192 - i].re = 0.0;
        in[8192 - i].im = -in[i].im;
    }
    fftw_one(p, in, out);
    for (i = 0;  i < 512;  i++)
    {
        plot[2*i] = 10*i;
        plot[2*i + 1] = out[i].re;
    }

    power->current();                                //setting coordinate
    power->rescale(CA_WHEN_MIN | CA_WHEN_MAX, P*1000);
    //P_P = new Ca_PolyLine(P_P, f, P*1000, FL_DASHDOT, 2, FL_RED, CA_NO_POINT);

    if (L_L)
        delete L_L;
	L_L = new Ca_Line(512, plot, 0/*FL_DOT*/, 0, FL_GREEN, CA_NO_POINT);

    Fl::add_timeout(.1, next_freq);
#if 0
    f *= FREQ_COEF;
    if (f <= MAX_FREQ)
    {
        Fl::add_timeout(.02, next_freq);
    }
    else
    {
		power->current();
		//new Ca_Text(1000,1, "Text\ntest!");
	}
#endif
};


int main(int argc, char ** argv) 
{
    Fl_Double_Window *w = new Fl_Double_Window(580, 380, "Power spectrum");
	Fl_Group *c = new Fl_Group(0, 35, 580, 345 );
    int i;

    c->box(FL_DOWN_BOX);
    c->align(FL_ALIGN_TOP | FL_ALIGN_INSIDE);

    canvas = new Ca_Canvas(180, 75, 300, 225, "Spectrum");
    canvas->box(FL_PLASTIC_DOWN_BOX);
    canvas->color(7);
    canvas->align(FL_ALIGN_TOP);
    Fl_Group::current()->resizable(canvas);
	// w->resizable(canvas);
    canvas->border(15);

    frequency = new Ca_X_Axis(185, 305, 295, 30, "Frequency [Hz]");
    frequency->align(FL_ALIGN_BOTTOM);
	frequency->scale(CA_LOG);
    frequency->minimum(MIN_FREQ);
    frequency->maximum(MAX_FREQ);
    frequency->label_format("%g");
    frequency->minor_grid_color(fl_gray_ramp(20));
    frequency->major_grid_color(fl_gray_ramp(15));
    frequency->label_grid_color(fl_gray_ramp(10));
    frequency->grid_visible(CA_MINOR_GRID | CA_MAJOR_GRID | CA_LABEL_GRID);
    //frequency->grid_visible(0);
    frequency->major_step(10);
    frequency->label_step(10);
	frequency->axis_color(FL_BLACK);
	frequency->axis_align(CA_BOTTOM | CA_LINE);

    power = new Ca_Y_Axis(100, 70, 78, 235, "P [mW]");
    power->align(FL_ALIGN_TOP);
    power->minor_grid_color(fl_gray_ramp(20));
    power->major_grid_color(fl_gray_ramp(15));
    power->label_grid_color(fl_gray_ramp(10));
	//power->grid_visible(CA_MINOR_TICK | CA_MAJOR_TICK | CA_LABEL_GRID | CA_ALWAYS_VISIBLE);
	power->grid_visible(CA_LABEL_GRID | CA_ALWAYS_VISIBLE);
	power->minor_grid_style(FL_DOT);
	power->minimum(-30000);                    //set initial range
    power->maximum(30000);
	//power->hide();

    power->current();

    //double d1[]={100,300,1000,3000,10000};
	//double d2[]={.2,1,0.5,0.7,0.2};
	//double d3[]={100,.2,300,1,1000,.5,3000,.7,10000,.2};
	//new Ca_Line(5, d3, FL_DOT,0,FL_RED,CA_ROUND|CA_BORDER);
	//new Ca_Bar(7000, 12000, 0.0011, 0.9, FL_RED,  FL_BLACK, 4,  "Bar", FL_ALIGN_TOP, FL_HELVETICA);
	//new Ca_Bar(5000, 10000, 0.0011, 0.4, FL_GREEN,  FL_BLACK, 4,  "Sec.\nbar", FL_ALIGN_TOP | FL_ALIGN_INSIDE, FL_HELVETICA);
	
    
	log_amp = new Fl_Light_Button(10, 310, 75, 25, "Log A");
	log_amp->callback(&type_callback);
    log_amp->box(FL_PLASTIC_UP_BOX);

	log_freq = new Fl_Light_Button(10, 340, 75, 25, "Log F");
	log_freq->callback(&type_callback);
    log_freq->box(FL_PLASTIC_UP_BOX);
	c->end();

    Fl_Group::current()->resizable(c);
    w->end();
    w->show();

    p = fftw_create_plan(512, FFTW_BACKWARD, FFTW_ESTIMATE);
    for (i = 0;  i < 8192;  i++)
    {
        in[i].re = 0.0;
        in[i].im = 0.0;
    }

    Fl::add_timeout(0, next_freq);
	Fl::run();
	return 0;
};
